#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
const int mxN = 3e5+5;

struct segTree
{
    vector<int> val;
    vector<int> lazy;
    int size;
    void print()
    {
        for(int i = 0; i < size; i++) cout << val[i] << " ";
        cout << "\n";
    }

    void build(vector<int>& a, int index, int Lx, int Rx)
    {
        if(Rx - Lx == 1)
        {
            if(Lx < a.size()) val[index] = a[Lx];
            else val[index] = -1;
            lazy[index] = -1;
            return;
        }
        int m = (Lx+Rx)/2;
        build(a, index*2+1,Lx,m);
        build(a, index*2+2,m,Rx);
        val[index] = max(val[index*2+1], val[index*2+2]);
        lazy[index] = -1;
    }
    void push(int index)
    {
        if(lazy[index] != -1)
        {
            val[index*2+1] = max(val[index*2+1], lazy[index]);
            lazy[index*2+1] = max(lazy[index*2+1], lazy[index]);
            val[index*2+2] = max(val[index*2+2], lazy[index]);
            lazy[index*2+2] = max(lazy[index*2+2], lazy[index]);
            lazy[index] = -1;
        }
    }
    void build(vector<int>& a)
    {
        size = 1;
        while(size < a.size()) size <<= 1;
        val = vector<int>(size << 1);
        lazy = vector<int>(size << 1);
        build(a, 0, 0, size);
    }
    int getmx(int l, int r, int i, int Lx, int Rx)
    {
        if(Lx >= l && Rx <= r) return val[i];
        if(Lx >= r || Rx <= l) return -1;
        push(i);
        int m = (Lx+Rx)/2;
        return max(getmx(l, r, i*2+1, Lx, m), getmx(l, r, i*2+2, m, Rx));
    }
    int getmx(int l, int r)
    {
        return getmx(l, r, 0, 0, size);
    }
    void setmx(int l, int r, int i, int v, int Lx, int Rx)
    {
        if(Lx >= l && Rx <= r)
        {
            val[i] = max(val[i], v);
            lazy[i] = max(val[i], v);
            return;
        }
        if(Lx >= r || Rx <= l) return;
        push(i);
        int m = (Lx+Rx)/2;
        setmx(l, r, i*2+1, v, Lx, m);
        setmx(l, r, i*2+2, v, m, Rx);
        val[i] = max(val[i*2+1], val[i*2+2]);
    }
    void setmx(int l, int r, int v)
    {
        setmx(l, r, 0, v, 0, size);
    }

};
int Slamke(int N, int* A, int M, int* T, int* X, int* Y)
{
    int n = N, m = M;
    vector<int> a(n);
    for(int i = 0; i < n; i++)
    {
        if(A[i+1] == 1) a[i] = 0;
        else a[i] = -1;
    }
    segTree tree; tree.build(a);
    for(int i = 1; i <= m; i++)
    {
        int op = T[i];
        if(op == 1)
        {
            int mx = tree.getmx(X[i]-1, Y[i]);
            if(mx != -1)
            {
                tree.setmx(X[i]-1, Y[i], mx);
            }
        }
        else
        {
            int mx = tree.getmx(X[i]-1, X[i]);
            if(mx != -1)
            {
                tree.setmx(X[i]-1, X[i], mx+1);
            }
        }
    }
    return tree.getmx(0, n);
}


/**
6
3 1 4 6 5 2
4
1 2 4
2 5 0
1 4 6
2 5 0
*/